<?php
/**
 * Admin Menu
 *
 * Initialize componentz admin menu.
 *
 * @author Componentz <support@componentz.co>
 * @package Componentz
 * @subpackage Componentz Theme
 * @since 1.0.0
 */

namespace Componentz\Admin;

// Do not allow direct access.
if( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Menu {

    /**
     * Instance
     *
     * Single instance of this object.
     *
     * @since 1.0.0
     * @access public
     * @var null|object
     */
    public static $instance = null;

    /**
     * Get Instance
     *
     * Access the single instance of this class.
     *
     * @since 1.0.0
     * @access public
     * @return object
     */
    public static function get_instance() {
        if ( null === self::$instance ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Class Constructor
     */
    public function __construct() {
        
        // Register componentz theme sub-menu in Appearance.
        add_action( 'admin_menu', [ $this, 'register_sub_menu' ] );

    }

    /**
     * Register Sub Menu
     *
     * Add a sub menu page to Appearance menu.
     *
     * @since 1.0.0
     * @access public
     * @return false|string
     */
    public function register_sub_menu() {
        if( has_action( 'componentz/theme/admin/add_theme_page' ) ) {
            /**
             * Hook: componentz/theme/admin/add_theme_page
             *
             * @hooked none
             *
             * @since 1.0.1
             */
            do_action( 'componentz/theme/admin/add_theme_page' );
        } else {
            add_theme_page(
                'Componentz',
                'Componentz',
                'edit_theme_options',
                'componentz',
                [ $this, 'page_content' ]
            );
        }
    }
    
    /**
     * Page Content
     *
     * Display Componentz admin page content.
     *
     * @since 1.0.0
     * @access public
     * @return mixed
     */
    public static function page_content() {
        $theme = wp_get_theme();
        $screen = get_current_screen();
        $changelog = Componentz()->dirPath( 'readme.txt' );
        $ExtrasPlugin = wp_normalize_path( WP_PLUGIN_DIR . '/componentz-extras/componentz-extras.php' );
        $ExtrasChangelog = wp_normalize_path( WP_PLUGIN_DIR . '/componentz-extras/CHANGELOG.txt' ); ?>
        <div class="wrap about-wrap wide-width-layout componentz-wrap">

            <div class="about-title-container">

                <h1 class="about-title"><img class="about-logo" alt="<?php esc_attr_e( 'componentz', 'componentz' ); ?>" src="<?php echo esc_url( get_template_directory_uri() ) . '/assets/img/icons/logo.svg'; ?>"/><?php _e( 'componentz', 'componentz' ); ?><span class="cz-ml-2"><?php _e( 'Control Panel', 'componentz' ); ?></span></h1>

                <div class="support-help">
                    <a href="<?php echo esc_url( 'https://docs.componentz.co/?utm_source=componentz-about&utm_medium=documentation-link&utm_campaign=about-page' ); ?>"
                       class="docs button" target="_blank"><?php _e( 'Documentation', 'componentz' ); ?>
                    </a>
                </div>

            </div>

            <div id="componentz-tabs">
                <div class="nav-tabs-container">

                <ul class="nav-tab-wrapper" aria-label="<?php esc_attr_e( 'componentz menu', 'componentz' ); ?>">
                    <li class="ui-tabs-active">
                        <a href="#componentz-getstarted" class="nav-tab nav-tab-active" aria-current="page">
                            <?php echo Componentz()->svg->icon( 'cz-icon-not-found' ); // phpcs:ignore ?><?php _e( 'Get Started', 'componentz' ); ?>
                        </a>
                    </li>
                    <li>
                        <a href="#componentz-changelog" class="nav-tab">
                            <?php echo Componentz()->svg->icon( 'cz-icon-changelog', true ); // phpcs:ignore ?><?php _e( 'Changelog', 'componentz' ); ?>
                        </a>
                    </li>

                    <?php
                    if( has_action( 'componentz/theme/admin_additional_tabs' ) ) {
                        /**
                         * Hook: componentz/theme/admin_additional_tabs
                         *
                         * @hooked none
                         *
                         * @since 1.0.0
                         */
                        do_action( 'componentz/theme/admin_additional_tabs' );
                    } ?>

                </ul>

                </div>

                <!-- Get Started -->
                <div id="componentz-getstarted" class="tab-content">
                    <div class="about-container">
                        <div class="about-row">

                            <div class="about-col product-screenshot">
                                <a href="<?php echo esc_url( 'https://componentz.co/theme/?utm_source=componentz-control-panel&utm_medium=theme-homepage-link&utm_campaign=about-page' ); ?>"
                                   target="_blank">
                                    <div class="screenshot-wrapper">
                                        <span class="product-type"><?php _e( 'Theme', 'componentz' ); ?></span>
                                        <span class="home-page-title"><?php _e( 'Theme homepage', 'componentz' ); ?><?php echo Componentz()->svg->icon( 'cz-icon-arrow', true ); // phpcs:ignore ?></span>
                                        <img src="<?php echo esc_url( get_template_directory_uri() ) . '/screenshot.png'; ?>"/>
                                   </div>
                                </a>
                            </div>

                            <div class="about-col">
                                <h4 class="product-title"><?php _e( 'componentz Theme', 'componentz' ); ?></h4>
                                <span class="version"><?php echo __( 'Version', 'componentz' ) . ' ' . esc_html( $theme->get( 'Version' ) ); ?></span>
                                <p class="about-text">
                                    <?php _e( 'Inspired by material design, based on flexible frameworks, designed with a passion for details. The theme you were looking for if you are an advanced developer or just a web enthusiast.', 'componentz' ); ?>
                                </p>
                                <h4><?php _e( 'Support', 'componentz' ); ?></h4>
                                <a href="<?php echo esc_url( 'http://wordpress.org/support/theme/componentz' ); ?>"
                                   class="button" target="_blank"><?php _e( 'Free Support Forums', 'componentz' ); ?>
                                </a>
                            </div>

                            <div class="about-col">
                                <h4><?php _e( 'Theme Live Customizer', 'componentz' ); ?></h4>
                                <p class="about-text">
                                    <?php _e( 'Set the theme options the way you like.', 'componentz' ); ?><br />
                                    <a href="<?php echo esc_url( admin_url( 'customize.php' ) ); ?>"
                                       class="button button-secondary cz-mt-1"><?php echo Componentz()->svg->icon( 'cz-icon-colors', true ); // phpcs:ignore ?><?php _e( 'Start to customize', 'componentz' ); ?>
                                    </a>
                                </p>

                                <h4><?php _e( 'Spread The Love &amp; Contribute', 'componentz' ); ?></h4>
                                <p class="about-text">
                                    <a href="https://wordpress.org/support/theme/componentz/reviews/?filter=5" class="button button-terciary" target="_blank">
                                        <?php echo Componentz()->svg->icon( 'cz-icon-rate', true ); // phpcs:ignore ?><?php _e( 'Rate it', 'componentz' ); ?>
                                    </a>
                                    <a href="https://translate.wordpress.org/projects/wp-themes/componentz" class="button button-terciary" target="_blank">
                                        <?php echo Componentz()->svg->icon( 'cz-icon-translate', true ); // phpcs:ignore ?><?php _e( 'Help us to translate', 'componentz' ); ?>
                                    </a>
                                </p>
                            </div>

                        </div>

                        <div class="about-row about-premium-extension">

                            <div class="about-col product-screenshot product-extension premium-plugin">
                                <h4><?php _e( 'Premium Extension', 'componentz' ); ?></h4>
                            </div>

                        </div>

                        <div class="about-row<?php if( ! file_exists( $ExtrasPlugin ) ) : ?> blur<?php endif; ?>">

                            <?php if( ! file_exists( $ExtrasPlugin ) ) : ?>
                                <div class="plugin-not-installed">

                                    <div class="plugin-not-installed-alert">

                                        <img src="<?php echo esc_url( get_template_directory_uri() ) . '/assets/img/extras.jpg'; ?>" />

                                        <h3><?php _e( 'Plugin not installed', 'componentz' ); ?></h3>

                                        <p><?php _e( 'componentz Extras turns the componentz theme to the next level with many great features which will help you to build an awesome site.', 'componentz' ); ?></p>

                                        <a href="<?php echo esc_url( 'https://componentz.co/theme/componentz-extras/?utm_source=componentz-control-panel&utm_medium=extras-learn-more-link&utm_campaign=about-page' ); ?>" target="_blank" class="button button-secondary cz-m-0 cz-mt-1">
                                            <?php _e( 'Learn More', 'componentz' ); ?>
                                        </a>
                                    </div>

                                </div>
                            <?php endif; ?>

                            <div class="about-col product-screenshot product-extension premium-plugin">
                                <a href="<?php echo esc_url( 'https://componentz.co/theme/componentz-extras/?utm_source=componentz-control-panel&utm_medium=extras-plugin-homepage-link&utm_campaign=about-page' ); ?>"
                                   target="_blank">
                                    <div class="screenshot-wrapper">
                                        <span class="product-type"><?php _e( 'Plugin', 'componentz' ); ?></span>
                                        <span class="home-page-title"><?php _e( 'Plugin homepage', 'componentz' ); ?><?php echo Componentz()->svg->icon( 'cz-icon-arrow', true ); // phpcs:ignore ?></span>
                                        <img src="<?php echo esc_url( get_template_directory_uri() ) . '/assets/img/extras.jpg'; ?>"/>
                                    </div>
                                </a>
                            </div>

                            <div class="about-col">
                                <h4 class="product-title"><?php _e( 'componentz Extras', 'componentz' ); ?></h4>

                                <?php if( file_exists( $ExtrasPlugin ) ) : ?>
                                    <span class="version"><?php echo __( 'Version', 'componentz' ) . ' ' . esc_html( get_option( '_ComponentzExtrasVersion' ) ); ?></span>
                                <?php endif; ?>

                                <?php if( ! file_exists( $ExtrasPlugin ) ) : ?>
                                    <div class="cz-alert cz-alert-warning cz-alert-extension">
                                        <span class="cz-mr-1"><?php echo componentz_svg( 'cz-icon-help', true ); // phpcs:ignore ?></span><?php _e( 'componentz Extras plugin not installed', 'componentz' ); ?>

                                        <a href="<?php echo esc_url( 'https://componentz.co/theme/componentz-extras/?utm_source=componentz-control-panel&utm_medium=extras-learn-more-link&utm_campaign=about-page' ); ?>" target="_blank" class="button cz-m-0 cz-mt-1">
                                            <?php _e( 'Learn More', 'componentz' ); ?>
                                        </a>
                                    </div>
                                <?php endif; ?>

                                <?php if( file_exists( $ExtrasPlugin ) && ! class_exists( 'Componentz\Extras\Plugin' ) ) : ?>
                                    <div class="cz-alert cz-alert-warning cz-alert-extension">
                                        <span class="cz-mr-1"><?php echo componentz_svg( 'cz-icon-help', true ); // phpcs:ignore ?></span><?php _e( 'componentz Extras plugin installed but not active', 'componentz' ); ?>

                                        <button type="button" class="button cz-m-0 cz-mt-1 activate-extras-plugin">
                                            <span class="cz-spin"><?php echo Componentz()->svg->icon( 'cz-icon-update', true ); // phpcs:ignore ?></span><?php _e( 'Activate', 'componentz' ); ?>
                                        </button>
                                    </div>
                                <?php endif; ?>

                                <?php if( class_exists( 'Componentz\Extras\Plugin' ) ) : ?>
                                    <div class="cz-alert cz-alert-success cz-alert-extension">
                                        <span class="cz-mr-1"><?php echo componentz_svg( 'cz-icon-ok', true ); // phpcs:ignore ?></span><?php _e( 'Plugin active', 'componentz' ); ?>
                                    </div>
                                <?php endif; ?>

                                <h4><?php _e( 'Support', 'componentz' ); ?></h4>
                                <a href="<?php echo esc_url( 'https://componentz.co/forums/forum/componentz-theme/?utm_source=componentz-control-panel&utm_medium=extras-support-forums-link&utm_campaign=about-page' ); ?>"
                                   class="button" target="_blank"><?php _e( 'Premium Support Forums', 'componentz' ); ?>
                                </a>
                            </div>

                            <div class="about-col">
                                <h4><?php _e( 'Translate Plugin', 'componentz' ); ?></h4>
                                <p class="about-text">
                                    <a href="<?php echo esc_url( 'https://docs.componentz.co/get-started/plugin-basics/plugin-translation/?utm_source=componentz-control-panel&utm_medium=extras-translate-link&utm_campaign=about-page' ); ?>" class="button button-terciary" target="_blank">
                                        <?php echo Componentz()->svg->icon( 'cz-icon-translate', true ); // phpcs:ignore ?><?php _e( 'Help us to translate', 'componentz' ); ?>
                                    </a>
                                </p>
                            </div>

                        </div>

                    </div>
                </div><!-- Get Started End -->

                <!-- Changelog -->
                <div id="componentz-changelog" class="tab-content">
                    <div class="about-container">
                        <div class="about-row">
                            <div class="changelog-col">
                                <h4><?php _e( 'componentz Theme', 'componentz' ); ?></h4>
                                <div class="about-text">
                                    <div id="cz-changelog" class="cz-changelog"><?php
                                        $allowed_html = [
                                            'h4' => [],
                                            'p' => [],
                                            'svg' => [
                                                'class' => [],
                                                'aria-hidden' => [],
                                                'role' => []
                                            ],
                                            'use' => [
                                                'xlink:href' => []
                                            ],
                                            'path' => [
                                                'd' => []
                                            ]
                                        ];
                                        if( is_readable( $changelog ) ):
                                            $parts = new \SplFileObject( $changelog );
                                            foreach( $parts as $line ) :
                                                $line = esc_html( $line );
                                                $line = preg_replace( '/=(.*?)=/', '<h4>$1</h4>', $line );
                                                if( ! preg_match( '/<h4>/', $line ) ) {
                                                    $line = '<p>' . $line;
                                                }
                                                if( ! preg_match( '/<\/h4>/', $line ) ) {
                                                    $line = '</p>' . $line;
                                                }
                                                $line = str_replace( '[new]', Componentz()->svg->icon( 'cz-icon-ok', true ), $line ); // phpcs:ignore
                                                $line = str_replace( '[updated]', Componentz()->svg->icon( 'cz-icon-update', true ), $line ); // phpcs:ignore
                                                $line = str_replace( '[fixed]', Componentz()->svg->icon( 'cz-icon-fix', true ), $line ); // phpcs:ignore
                                                $line = str_replace( '[improved]', Componentz()->svg->icon( 'cz-icon-fix', true ), $line ); // phpcs:ignore
                                                echo wp_kses( $line, $allowed_html );
                                            endforeach;
                                        endif; ?>
                                    </div>
                                </div>
                            </div>

                            <div class="changelog-col">
                                <h4 class="product-title product-title-changelog"><?php _e( 'componentz Extras', 'componentz' ); ?></h4>
                                <span class="<?php echo is_rtl() ? 'cz-mr-1' : 'cz-ml-1'; ?> extension"><?php _e( 'Premium Extension', 'componentz' ); ?></span>
                                <div class="about-text">
                                    
                                    <?php if( ! file_exists( $ExtrasPlugin ) ) : ?>
                                    <div class="cz-alert cz-alert-warning cz-alert-extension">
                                        <span class="cz-mr-1"><?php echo componentz_svg( 'cz-icon-help', true ); // phpcs:ignore ?></span><?php _e( 'componentz Extras plugin not installed', 'componentz' ); ?>

                                        <a href="<?php echo esc_url( 'https://componentz.co/theme/componentz-extras/?utm_source=componentz-control-panel&utm_medium=extras-learn-more-link&utm_campaign=about-page' ); ?>" target="_blank" class="button cz-m-0 cz-ml-1">
                                            <?php _e( 'Learn More', 'componentz' ); ?>
                                        </a>
                                    </div><br>
                                    <?php endif; ?>
                                    
                                    <?php if( file_exists( $ExtrasPlugin ) && ! class_exists( 'Componentz\Extras\Plugin' ) ) : ?>
                                    <div class="cz-alert cz-alert-warning cz-alert-extension">
                                        <span class="cz-mr-1"><?php echo componentz_svg( 'cz-icon-help', true ); // phpcs:ignore ?></span><?php _e( 'componentz Extras plugin installed but not active', 'componentz' ); ?>

                                        <button type="button" class="button cz-m-0 cz-ml-1 activate-extras-plugin">
                                            <span class="cz-spin"><?php echo Componentz()->svg->icon( 'cz-icon-update', true ); // phpcs:ignore ?></span><?php _e( 'Activate', 'componentz' ); ?>
                                        </button>
                                    </div>
                                    <br>
                                    <?php endif; ?>
                                    
                                    <?php if( class_exists( 'Componentz\Extras\Plugin' ) ) : ?>
                                    <div id="cz-extras-changelog" class="cz-changelog"><?php
                                        $allowed_html = [
                                            'h4' => [],
                                            'p' => [],
                                            'svg' => [
                                                'class' => [],
                                                'aria-hidden' => [],
                                                'role' => []
                                            ],
                                            'use' => [
                                                'xlink:href' => []
                                            ],
                                            'path' => [
                                                'd' => []
                                            ]
                                        ];
                                        if( file_exists( $ExtrasChangelog ) && is_readable( $ExtrasChangelog ) ):
                                            $parts = new \SplFileObject( $ExtrasChangelog );
                                            foreach( $parts as $line ) :
                                                $line = esc_html( $line );
                                                $line = preg_replace( '/=(.*?)=/', '<h4>$1</h4>', $line );
                                                if( ! preg_match( '/<h4>/', $line ) ) {
                                                    $line = '<p>' . $line;
                                                }
                                                if( ! preg_match( '/<\/h4>/', $line ) ) {
                                                    $line = '</p>' . $line;
                                                }
                                                $line = str_replace( '[new]', Componentz()->svg->icon( 'cz-icon-ok', true ), $line ); // phpcs:ignore
                                                $line = str_replace( '[updated]', Componentz()->svg->icon( 'cz-icon-update', true ), $line ); // phpcs:ignore
                                                $line = str_replace( '[fixed]', Componentz()->svg->icon( 'cz-icon-fix', true ), $line ); // phpcs:ignore
                                                $line = str_replace( '[improved]', Componentz()->svg->icon( 'cz-icon-fix', true ), $line ); // phpcs:ignore
                                                echo wp_kses( $line, $allowed_html );
                                            endforeach;
                                        endif; ?>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Changelog End -->

                <?php
                if( has_action( 'componentz/theme/admin_additional_content' ) ) {
                    /**
                     * Hook: componentz/theme/admin_additional_content
                     *
                     * @hooked none
                     *
                     * @since 1.0.0
                     */
                    do_action( 'componentz/theme/admin_additional_content' );
                } ?>

            </div>

        </div>
        <?php
    }

}

Menu::get_instance();

/* Omit closing PHP tag to avoid "Headers already sent" issues. */
