<?php
/**
 * Componentz Ajax
 *
 * The main componentz Ajax class.
 *
 * @author Componentz <support@componentz.co>
 * @package Componentz
 * @subpackage Componentz Theme
 * @since 1.0.0
 */

namespace Componentz;

// Do not allow direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Ajax {
    
    /**
	 * Instance
	 *
	 * Single instance of this object.
	 *
	 * @since 1.0.0
	 * @access public
	 * @var null|object
	 */
	public static $instance = null;

	/**
	 * Get Instance
	 *
	 * Access the single instance of this class.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}
    
    /**
     * Class Constructor
     */
    public function __construct() {
        
        add_action( 'wp_ajax_activate_Extras_plugin', [ $this, 'activate_Extras_plugin' ] );
        
    }
    
    /**
     * Activate Extras Plugin
     *
     * Activate componentz Extras plugin on request.
     *
     * @since 1.0.0
     * @access public
     * @return WP_Error|null
     */
    public function activate_Extras_plugin() {
        $Plugin = wp_normalize_path( WP_PLUGIN_DIR . '/componentz-extras/componentz-extras.php' );
        if( file_exists( $Plugin ) ) {
            $result = activate_plugin( 'componentz-extras/componentz-extras.php' );
            if( ! is_wp_error( $result ) ) {
                echo true;
            }
            die();
        }
    }
    
}

/* Omit closing PHP tag to avoid "Headers already sent" issues. */
