<?php
/**
 * Searchform
 *
 * The custom searchform of the theme.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @author Componentz <support@componentz.co>
 * @package Componentz
 * @subpackage Componentz Theme
 * @since 1.0.0
 */

// Do not allow direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} ?>

<!-- Searchform -->
<form action="<?php echo esc_url( home_url() ); ?>" method="get" class="search-form">
    <input type="text" name="s" class="cz-form-control"
           value="<?php echo get_search_query(); ?>" 
           placeholder="<?php esc_attr_e( 'Search the website', 'componentz' ); ?>"/>
    <button class="search-button" type="submit"><?php echo Componentz()->svg->icon( 'cz-icon-arrow-right' ); // phpcs:ignore ?></button>
</form><!-- Searchform End -->
